define(['angular', 'app', 'moment'], function (angular, app, moment) {
	'use strict';

	app.controller('NotificationsSummaryController', function ($scope, $filter, $state, $stateParams, NotificationsPreferencesService, NotificationsInstanceBuilderService, NotificationsConstants, focusService, formatter) {
		$scope.getDetails = function (item) {
			$stateParams.id = service.idGetter(item);

			if ($stateParams.id) {
				$state.go('^.detail', $stateParams);
				if(!item.readFlag) {
					var saveItem = angular.copy(item);
					saveItem.readFlag = true;
					service.save(saveItem);
				}
			}
		};
		
		var service = NotificationsInstanceBuilderService.instance($stateParams.section);
		var minDate = moment().subtract(1,'year').format('L'),
			defaultMin = moment().subtract(30,'day').format('L'),
			defaultMax = moment().format('L'),
			allowedDateRange = {
				min: minDate
			};

		$scope.allowedDateRange = allowedDateRange;

		// angular.extend adds filter object to $scope
		angular.extend($scope, angular.copy(NotificationsConstants[$stateParams.section].summary));
		$scope.sectionTitle = $filter('filter')($state.current.data.paramSections, { paramValue: $stateParams.section }, true)[0].sectionName;
		$scope.noResultsMessage = 'No results found.';

		// filter init
		$scope.statusOptions = ['Unread', 'Read', 'All'];
		$scope.filter.service = service;
		$scope.filter.defaults.status = 'All';
		$scope.filter.defaults.startDate = defaultMin;
		$scope.filter.defaults.endDate = defaultMax;

		$scope.typeOptions = {
			options: [
				{label: 'All Notifications', value: 'FIT_HEART,STAFF'},
				{label: 'VA FitHeart App Notices', value: 'FIT_HEART'},
				{label: 'VA Health Messages', value: 'STAFF'}
			]
		};

		// summary table setup
		$scope.table = {
			columns : [
				{
					ngIconClass: function (item) { return { 'icon-dot-indicator': !item.readFlag }; },
					class: { column: 'read-indicator-column hidden-xs' },
					cellTemplate: 'src/modules/notifications/pages/summary/partials/_notification-status-icon-column.html',
					label: 'Status'
				},
				{ label: 'Notification', cellTemplate: 'src/modules/notifications/pages/summary/partials/_notification-column.html'}
			],
			rows : {
				ngClass: function (item) { return { 'bold': !item.readFlag }; }
			}
		};

		if ($stateParams.section === 'all-notifications')
			$scope.table.columns.push({label: 'Source', keys: 'source', class: { column: 'hidden-xs' }});
		$scope.table.columns.push({label: 'Date', cellTemplate: 'src/modules/notifications/pages/summary/partials/_date-column.html'});

		if ($stateParams.section != 'fit-heart-notices' && typeof NotificationsPreferencesService.dataPointers.notificationPreference.optInSelected !== 'boolean')
			NotificationsPreferencesService.getNotificationsPreference();

		$scope.preferenceDataPointers = NotificationsPreferencesService.dataPointers;

		if (!service.dataPointers.list) {
			NotificationsPreferencesService.getNotificationsPreference().then(function (response) {
				$scope.filter.defaults.isOptedIn = response.optInSelected;
				service.fetch($scope.filter.defaults);
			});
		} 
		else {
			service.fetch(service.dataPointers.filters);
		}
	});
});